﻿using System;

class Program
{
    static void Main(string[] args)
    {
        Oberklasse ober = new Unterklasse();
        //ober.PrintSomething();
        ober.Print();
        Console.Read();
    }
}

//Für den Vererbungsvorgang muss die Tochterklasse <= der Zugriffsberechtigung der Mutterklasse sein
//Daher gilt: protected : public ist OK aber public : protected ist NICHT ok.

//class Oberklasse
public class Oberklasse
{
    public Oberklasse()
    {
        Console.WriteLine("Oberklasse wird erstellt...");
    }

    public Oberklasse(bool expl)
    {
        Console.WriteLine("Andere Oberklasse wird erstellt...");
    }

    //private int wert;
    public int wert;

    //Eigenschaften
    public int Wert
    {
        get { return wert; }
        private set
        {
            wert = value;
        }
    }

    //protected virtual void PrintSomething()
    protected void PrintSomething()
    {
        Console.WriteLine("Something...");
    }

    public void Print()
    {
        PrintSomething();
    }
}

//public class Unterklasse : Oberklasse
class Unterklasse : Oberklasse
{
    //Merke: Ein Konstruktor der Basisklasse wird IMMER aufgerufen

    //public Unterklasse() : base(true)
    public Unterklasse()
    {
        Console.WriteLine("Unterklasse wird erstellt...");

        //Auf Wert kann nur zugegriffen werden wenn dieser auch sichtbar ist
        //Merke: Private --> nicht sichtbar, Protected --> private, Public --> public (also sichtbar)
        //Bedeutung von Protected ist wie private aber mit Vererbung!
        wert = 5;

        //Vergleiche Eigenschaften
        //Wert = 5;
        Console.WriteLine(Wert);
    }

    //Vergleiche: Beim VERSTECKEN muss die Methode direkt angesprochen werden d.h. Print() aus der Basisklasse spricht PrintSomething()
    //aus der Basisklasse an - beim ÜBERSCHREIBEN würde Print() aus der Basisklasse die aktuellste Implementierung von PrintSomething()
    //ansprechen

    //protected override void PrintSomething()
    protected new void PrintSomething()
    {
        Console.WriteLine("Something else...");
    }
}
